%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for educational purposes 
%   associated with the book
%
%
%


%   Charged disk -- symbolic and analytical solutions


clear all;
close all;
syms r z
rho = 0.002;
a = 0.1;
EPS0 = 8.8542 * 10^(-12);
z = -2*a:0.05*a:2*a;
R = sqrt(r^2 + z.^2);
f = z./R.^3;
t = rho*2*r*pi/(4*pi*EPS0);
E = integral(f,t,r,0,a);
E1 = double(E);
Ea = rho/(2*EPS0)*(z./abs(z)- z./sqrt(a^2+z.^2));
Ea1 = double(Ea);
plot (z,E1,'rx',z,Ea1,'k','LineWidth',1.4);
xlabel('z[m]');
ylabel('Ez[V/m]');
legend('Symbolic solution','Analytical solution');
title('Charged disk');